"use client";

import { usePathname } from 'next/navigation';
import Navbar from "@/components/Navbar";
import Footer from "@/components/Footer";
import { Setting } from "@/types/setting";

interface ClientLayoutProps {
  children : React.ReactNode;
  settings : Setting[];
}

export default function ClientLayout({ children, settings }: ClientLayoutProps) {
  const pathname = usePathname();
  const hideLayout = pathname === '/';

  return (
    <>
      {!hideLayout && <Navbar />}
        {children}
      {!hideLayout && <Footer settings={settings} />}
    </>
  );
}
