import BreadCumb from "@/components/BreadCumb"
import Link from "next/link";
import { fetchSettings } from "@/lib/apis/settings";
import { mapSettingsByKey } from "@/lib/mapSettings";
import ContactForm from "./ContactForm";

export const metadata = {
    title: "Get In Touch",
    description: "Have questions or feedback? Reach out to our support team via this contact form.",
    openGraph: {
        title: "Contact Us",
        description: "Get in touch with us — we'd love to hear from you.",
        url: "https://yourdomain.com/contact-us",
    },
    twitter: {
        card: "summary",
        title: "Contact Us",
        description: "Reach out to our support team via this contact form.",
    },
};

export default async function ContactUs() {
    const settings = await fetchSettings();
    const settingsV = mapSettingsByKey(settings);

    return (
        <>
        <BreadCumb/>
            <section className="contact-wrapper py-120">
                <div className="container">
                    <div className="row justify-content-center">
                        <div className="col-lg-10 col-sm-12">
                            <div className="section-head text-center">
                                <h2>Get In Touch </h2>
                                <div className="discription">
                                    <p>Cheminco is a trading company - leading provider of industrial materials, crop inputs and shipping and logistic services across three continents. Throughout our Company’s history, we have recognized the need for social, economic and environmental responsibility in all areas of our business.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div className="row">
                        <div className="col-12">
                            <ul className="addressing-list">
                            {settingsV?.office_location && (
                                <li className="addressing-list-item">
                                    <div className="iconbox">
                                        <svg width="13" height="17" viewBox="0 0 13 17" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M5.27686 16.0938C4.71436 15.4062 4.01644 14.4792 3.18311 13.3125C2.37061 12.1667 1.65186 10.9792 1.02686 9.75C0.401855 8.52083 0.0685221 7.4375 0.0268555 6.5C0.0685221 4.79167 0.651855 3.375 1.77686 2.25C2.90186 1.125 4.31852 0.541667 6.02686 0.5C7.73519 0.541667 9.15186 1.125 10.2769 2.25C11.4019 3.375 11.9852 4.79167 12.0269 6.5C11.9852 7.4375 11.6519 8.52083 11.0269 9.75C10.381 10.9792 9.65186 12.1667 8.83936 13.3125C8.02686 14.4792 7.33936 15.4062 6.77686 16.0938C6.56852 16.3438 6.31852 16.4688 6.02686 16.4688C5.73519 16.4688 5.48519 16.3438 5.27686 16.0938ZM6.02686 8.5C6.58936 8.47917 7.05811 8.28125 7.43311 7.90625C7.80811 7.53125 8.00602 7.0625 8.02686 6.5C8.00602 5.9375 7.80811 5.46875 7.43311 5.09375C7.05811 4.71875 6.58936 4.52083 6.02686 4.5C5.46436 4.52083 4.99561 4.71875 4.62061 5.09375C4.24561 5.46875 4.04769 5.9375 4.02686 6.5C4.04769 7.0625 4.24561 7.53125 4.62061 7.90625C4.99561 8.28125 5.46436 8.47917 6.02686 8.5Z" fill="currentcolor"></path>
                                        </svg>                                
                                    </div>
                                    <div className="fd-content">
                                        <span>Office location</span>
                                        <p>{settingsV?.office_location}</p>
                                    </div>
                                </li>
                                 )}
                                {settingsV?.contact_support_email && (
                                <li className="addressing-list-item">
                                    <div className="iconbox">
                                        <svg width="17" height="12" viewBox="0 0 17 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M8.19324 9C7.6724 9 7.18282 8.83333 6.72449 8.5L0.193237 3.40625V10.5C0.214071 10.9167 0.359904 11.2708 0.630737 11.5625C0.922404 11.8333 1.27657 11.9792 1.69324 12H14.6932C15.1099 11.9792 15.4641 11.8333 15.7557 11.5625C16.0266 11.2708 16.1724 10.9167 16.1932 10.5V3.40625L9.66199 8.5C9.20365 8.83333 8.71407 9 8.19324 9ZM0.693237 2.53125L7.31824 7.6875C7.58907 7.89583 7.88074 8 8.19324 8C8.50574 8 8.7974 7.89583 9.06824 7.6875L15.6932 2.53125C16.0057 2.26042 16.1724 1.91667 16.1932 1.5C16.1724 1.08333 16.0266 0.729167 15.7557 0.4375C15.4641 0.166667 15.1099 0.020833 14.6932 0H1.69324C1.27657 0.020833 0.922404 0.166667 0.630737 0.4375C0.359904 0.729167 0.214071 1.08333 0.193237 1.5C0.193237 1.91667 0.359904 2.26042 0.693237 2.53125Z" fill="currentcolor"></path>
                                        </svg>                                                              
                                    </div>
                                    <div className="fd-content">
                                        <span>Send Email</span>
                                        <Link href={`mailto:${settingsV?.contact_support_email}`}>{settingsV?.contact_support_email}</Link>
                                    </div>
                                </li>
                                 )}
                                {settingsV?.contact_support_phone && (
                                <li className="addressing-list-item">
                                    <div className="iconbox">
                                        <svg width="17" height="16" viewBox="0 0 17 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M9.04932 5.68757C8.65348 5.43757 8.29932 5.46882 7.98682 5.78132C7.71598 6.17715 7.74723 6.53132 8.08057 6.84382C8.45557 7.15632 8.64307 7.54174 8.64307 8.00007C8.64307 8.4584 8.45557 8.84382 8.08057 9.15632C7.74723 9.46882 7.71598 9.82299 7.98682 10.2188C8.13265 10.3855 8.32015 10.4688 8.54932 10.4688C8.73682 10.4688 8.90348 10.4167 9.04932 10.3126C9.75765 9.7084 10.1222 8.93757 10.1431 8.00007C10.1222 7.06257 9.75765 6.29174 9.04932 5.68757ZM10.9243 3.34382C10.5493 3.09382 10.1951 3.12507 9.86182 3.43757C9.61182 3.8334 9.65348 4.18757 9.98682 4.50007C11.0701 5.41674 11.6222 6.57299 11.6431 7.96882C11.6222 9.36465 11.0701 10.5209 9.98682 11.4376C9.65348 11.7709 9.61182 12.1251 9.86182 12.5001C10.0285 12.6876 10.2264 12.7813 10.4556 12.7813C10.6222 12.7813 10.7785 12.7188 10.9243 12.5938C11.6326 12.0313 12.1743 11.3438 12.5493 10.5313C12.9451 9.73965 13.1431 8.88549 13.1431 7.96882C13.1014 6.11465 12.3618 4.57299 10.9243 3.34382ZM12.8306 1.03132C12.4556 0.78132 12.1118 0.81257 11.7993 1.12507C11.5285 1.5209 11.5597 1.87507 11.8931 2.18757C12.7681 2.91674 13.4451 3.78132 13.9243 4.78132C14.4035 5.78132 14.6431 6.84382 14.6431 7.96882C14.6431 9.09382 14.4035 10.1667 13.9243 11.1876C13.4451 12.1876 12.7681 13.0522 11.8931 13.7813C11.5597 14.0938 11.5285 14.448 11.7993 14.8438C11.9451 15.0105 12.1326 15.0938 12.3618 15.0938C12.5285 15.0938 12.6847 15.0417 12.8306 14.9376C13.8931 14.0834 14.7056 13.0522 15.2681 11.8438C15.8514 10.6355 16.1431 9.34382 16.1431 7.96882C16.1431 6.59382 15.8514 5.31257 15.2681 4.12507C14.7056 2.93757 13.8931 1.90632 12.8306 1.03132ZM4.86182 5.46882C5.21598 5.46882 5.4764 5.31257 5.64307 5.00007L6.70557 2.34382C6.80973 1.94799 6.70557 1.6459 6.39307 1.43757L4.29932 0.12507C3.96598 -0.0624313 3.65348 -0.0311813 3.36182 0.21882C1.92432 1.67715 0.965983 3.34382 0.486816 5.21882C0.0284831 7.07299 0.0284831 8.92715 0.486816 10.7813C0.965983 12.6563 1.92432 14.323 3.36182 15.7813C3.65348 16.0313 3.96598 16.0626 4.29932 15.8751L6.39307 14.5626C6.70557 14.3334 6.80973 14.0313 6.70557 13.6563L5.64307 11.0313C5.49723 10.698 5.23682 10.5417 4.86182 10.5626L3.20557 10.7188C2.6014 8.90632 2.6014 7.09382 3.20557 5.28132L4.86182 5.46882Z" fill="currentcolor"></path>
                                        </svg>                                                               
                                    </div>
                                    <div className="fd-content">
                                        <span>Call</span>
                                        <Link  href={`tel:${settingsV?.contact_support_phone}`}>{settingsV?.contact_support_phone}</Link>
                                    </div>
                                </li>
                                )}
                            </ul>

                            <ContactForm />
                            
                        </div>
                    </div>
                </div>
            </section>
    
            <section className="map-wrapper">
                {/* <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d302775.7595395091!2d75.62574683476568!3d26.885115145593463!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x396c4adf4c57e281%3A0xce1c63a0cf22e09!2sJaipur%2C%20Rajasthan!5e1!3m2!1sen!2sin!4v1744287411040!5m2!1sen!2sin" width="100%" height="450"  loading="lazy" referrerPolicy="no-referrer-when-downgrade"></iframe> */}



                <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d387200.0828554982!2d-74.60334784222081!3d40.69598339117142!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x89c24fa5d33f083b%3A0xc80b8f06e177fe62!2sNew%20York%2C%20NY%2C%20USA!5e0!3m2!1sen!2sin!4v1747743195142!5m2!1sen!2sin" width="100%" height="450"  loading="lazy" referrerPolicy="no-referrer-when-downgrade"></iframe>
            </section>
        </>
    );
}