import BreadCumb from "@/components/BreadCumb"
import Link from "next/link";
import { fetchSettings } from "@/lib/apis/settings";
import { mapSettingsByKey } from "@/lib/mapSettings";
import ImageComp from "@/components/Shared/Image";

export const metadata = {
    title: "Cheminco sources and supplies many of the petroleum products",
    description: "Cheminco sources and supplies many of the petroleum products, including diesel, jet fuel, bunker and light fuel oil. All our fuels comply with environmental regulations and enhance their performance for end-users.",
    openGraph: {
        title: "Contact Us",
        description: "Cheminco sources and supplies many of the petroleum products, including diesel, jet fuel, bunker and light fuel oil. All our fuels comply with environmental regulations and enhance their performance for end-users.",
        url: "https://yourdomain.com/contact-us",
    },
    twitter: {
        card: "summary",
        title: "Cheminco sources and supplies many of the petroleum products",
        description: "Cheminco sources and supplies many of the petroleum products, including diesel, jet fuel, bunker and light fuel oil. All our fuels comply with environmental regulations and enhance their performance for end-users.",
    },
};

export default async function ourProduct() {
    return (
        <>
        <BreadCumb/>
        <section className="petrochemicals-products-wrapper py-120 pb-0">
            <div className="container">
                <p className="text-center products-dec-text">
                    Cheminco sources and supplies many of the petroleum products, including diesel, jet fuel, bunker and light fuel oil. All our fuels comply with environmental regulations and enhance their performance for end-users.
                </p>
                <div className="row">
                    <div className="col-12">
                        <div className="sources-imges text-center py-80">
                            <ImageComp src='/images/sources-imges.webp' className="img-fluid" alt="sources-imges" width={1026} height={799}  />
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <section className="supplyChain-efficiency-wrapper py-120">
            <div className="container">
                <div className="row">
                    <div className="col-12 col-md-6 col-lg-5">
                        <div className="girdimges">
                            <div className="aboutshap-01">
                                <ImageComp src='/images/our-supply-chain-img01.webp' alt="our-supply-chain-img01" width={674} height={594} />
                            </div>
                            <div className="aboutshap-03">
                                <ImageComp src='/images/our-supply-chain-img02.webp' alt="our-supply-chain-img02" width={315} height={472} />
                            </div>
                        </div>
                    </div>
                    <div className="col-12 col-md-6 col-lg-7">
                        <div className="supplyChain-content">
                            <div className="dim-text">Supply Chain Efficiency</div>
                            <h2 className="ds-title">Our Supply Chain</h2>
                            <p className="dec-text">
                                Our strategies for efficient supply chain management involve the ability to deliver products at strategic or required locations or storage tanks. <br /> <br />
                            </p>
                            <p className="dec-text">
                                Logistics and distribution are at the core of the business. For our transportation needs, we maintain good relationships with the world’s major ship owners and brokers, ensuring an access to the best shipping assets. 
                                <br />
                                Vessels are chartered on a spot or time-charter basis.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section className="transport-wrapper py-120 pt-0">
            <div className="container">
                <div className="transport-row-map text-center">
                    <ImageComp src='/images/transport-map.webp' className="img-fluid desk-device-img" alt="aboutus-img03" width={1216} height={390} />
                    <ImageComp src='/images/transport-map-mb.webp' className="img-fluid mb-device-img" alt="transport-map-mb" width={1216} height={390} />
                </div>
            </div>
            <div className="ourproduct-shap">
                <ImageComp src='/images/transport-shap.webp' className="img-fluid" alt="transport-shap" width={374} height={212}  />
            </div>
        </section>
        </>
    );
}