"use client";

import BreadCumb from "@/components/BreadCumb";
import ImageComp from "@/components/Shared/Image";

export default function Services() {
    return (
        <>
        <BreadCumb />

        <section className="service-wrapper py-120"> 
            <div className="md-container">
                <div className="row">
                    <div className="col-12 col-md-6">
                        <div className="service-img">
                            <ImageComp src='/images/serviceimg01.webp' alt="serviceimg01" width={815} height={508}  />
                        </div>
                    </div>
                    <div className="col-12 col-md-6">
                        <div className="service-content">
                            <div className="dim-text">
                                Our Services
                            </div>
                            <p className="dec-text">
                                Cheminco is a leading provider of crop inputs, industrial materials and services across four continents. <br />
                                We operate a world-class network of distribution that positions us to efficiently serve the needs of farmers, companies involved in the exploration and mining and producers of civil explosives. <br /><br />

                                We focus on creating long-term value by strengthening the advantages of our business that is built across the agricultural and mining value chain and by maintaining access to the best resources and relationships with global manufacturers of industrial chemicals and mineral fertilizers needed to achieve our goals. <br /><br />

                                Cheminco provides a wide variety of day to day services ranging from handling of industrial chemicals and fertilizers in various ports across Europe, China and Asia-Pacific including bagging, warehousing, container and vessel loading and chartering. <br /><br />

                                Cheminco has established distribution networks across Europe, Central Asia, China, Asia Pacific and Africa offering safe delivery of the products to every customer.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section className="our-distribution-wrapper py-120 pt-0">
            <div className="md-container">
                <div className="row">
                    <div className="col-12">
                        <div className="title-distribution">
                            <h2>
                                Our Distribution Networks
                            </h2>
                        </div>
                        <div className="distribution-network-list">
                            <div className="network-itemt">
                                <div className="icon">
                                    <ImageComp src='/images/network01.webp' alt="network01" width={148} height={150} />
                                </div>
                                <h5>
                                    Europe
                                </h5>
                            </div>
                            <div className="network-itemt">
                                <div className="icon">
                                    <ImageComp src='/images/network02.webp' alt="network02" width={148} height={150} />
                                </div>
                                <h5>
                                    Central Asia
                                </h5>
                            </div>
                            <div className="network-itemt">
                                <div className="icon">
                                    <ImageComp src='/images/network03.webp' alt="network03" width={148} height={150} />
                                </div>
                                <h5>
                                    China
                                </h5>
                            </div>
                            <div className="network-itemt">
                                <div className="icon">
                                    <ImageComp src='/images/network04.webp' alt="network04" width={148} height={150} />
                                </div>
                                <h5>
                                    Asia Pacific
                                </h5>
                            </div>
                            <div className="network-itemt">
                                <div className="icon">
                                    <ImageComp src='/images/network05.webp' alt="network05" width={148} height={150} />
                                </div>
                                <h5>
                                     Africa
                                </h5>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div className="container">
                <div className="row">
                    <div className="col-12">
                        <div className="distribution-place">
                            <div className="distribution-itemt">
                                <ImageComp src='/images/distribution01.webp' alt="distribution01" width={393} height={407} />
                            </div>
                            <div className="distribution-itemt">
                                <ImageComp src='/images/distribution02.webp' alt="distribution02" width={393} height={407} />
                            </div>
                            <div className="distribution-itemt">
                                <ImageComp src='/images/distribution03.webp' alt="distribution03" width={393} height={407} />
                            </div>
                            <div className="distribution-itemt">
                                <ImageComp src='/images/distribution04.webp' alt="distribution04" width={393} height={407} />
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        </>
    );
}