"use client";

import { useEffect, useRef, useState } from "react";
import Link from "next/link";
import ImageComp from "../Shared/Image";

export default function AboutSection(){

    const sectionRef = useRef(null);
    const [isActive, setIsActive] = useState(false);

    useEffect(() => {
        const observer = new IntersectionObserver(
            ([entry]) => {
                setIsActive(entry.isIntersecting);
            },
            { threshold: 0.3 }
        );

        if (sectionRef.current) {
            observer.observe(sectionRef.current);
        }

        return () => {
            if (sectionRef.current) {
                observer.unobserve(sectionRef.current);
            }
        };
    }, []);

    return (
        <section ref={sectionRef} className={`about-wrapper animated-section py-120 ${isActive ? "active" : ""}`}>
            <div className="container">
                <div className="row">
                    <div className="col-12 col-md-6 col-lg-5">
                        <div className="girdimges">
                            <div className="aboutshap-01">
                                <ImageComp src='/images/aboutus-img01.webp' alt="aboutus-img01" width={512} height={593} />
                            </div>
                            <div className="aboutshap-02">
                                <ImageComp src='/images/aboutus-img02.webp' alt="aboutus-img02" width={272} height={167} />
                            </div>
                            <div className="aboutshap-03">
                                <ImageComp src='/images/aboutus-img03.webp' alt="aboutus-img03" width={406} height={194} />
                            </div>
                        </div>
                    </div>
                    <div className="col-12 col-md-6 col-lg-7">
                        <div className="about-content subbox-data-content">
                            <div className="dim-text">
                                About Us
                            </div>
                            <h2 className="ds-title">
                                Our Business
                            </h2>
                            <p className="dec-text">
                                Cheminco is a trading company - leading provider of industrial materials, crop inputs and shipping and logistic services across three continents. Throughout our Company’s history, we have recognized the need for social, economic and environmental responsibility in all areas of our business. We have been supplying our customers with environmentally friendly chemicals and fertilizers that are free from harmful substances and heavy metals.
                            </p>
                            {/* <div className="primary-btn">
                                <Link href="#" className="btnprimary">
                                    Explore More
                                    <svg width="19" height="20" viewBox="0 0 19 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clipPath="url(#clip0_2001_21)">
                                        <path d="M10.7027 2.77344L17.7742 9.33594C17.9617 9.51823 18.0554 9.73958 18.0554 10C18.0554 10.2604 17.9617 10.4818 17.7742 10.6641L10.7027 17.2266C10.2206 17.5911 9.76524 17.5911 9.33667 17.2266C8.96167 16.7578 8.96167 16.3151 9.33667 15.8984L14.6804 10.9375H1.01971C0.43042 10.8854 0.108991 10.5729 0.0554199 10C0.108991 9.42708 0.43042 9.11458 1.01971 9.0625H14.6804L9.33667 4.10156C8.96167 3.6849 8.96167 3.24219 9.33667 2.77344C9.76524 2.40885 10.2206 2.40885 10.7027 2.77344Z" fill="white"/>
                                        </g>
                                        <defs>
                                        <clipPath id="clip0_2001_21">
                                        <rect width="18" height="20" fill="white" transform="matrix(1 0 0 -1 0.0554199 20)"/>
                                        </clipPath>
                                        </defs>
                                    </svg>
                                </Link>
                            </div> */}
                        </div>
                    </div>
                </div>
            </div>
            <div className="animation-right">
                <ImageComp src='/images/about-ani01.webp' alt="about-ani01" width={372} height={209} />
            </div>
        </section>
        );
}