'use client';

import AboutPetroChemical from "../AboutPetroChemical";
import Link from "next/link";
import ImageComp from "@/components/Shared/Image";

export default function PetroChemicalContent(){
    return (
        <>
            <section className="hero-wrapper-video">
                <div className="land-hero">
                    <video autoPlay muted loop playsInline style={{
                        width: "100%",
                        height: "100%",
                        objectFit: "cover"
                    }} >
                        <source src="/images/cheminco_petrochemicals.mp4" type="video/mp4" />
                        Your browser does not support the video tag.
                    </video>
                </div>
            </section>

            <AboutPetroChemical />

            <section className="what-wedo-wrapper petrochemicals-wedoBox position-relative">
                <div className="section-first py-120">
                    <div className="container">
                        <div className="row">
                            <div className="col-12 col-md-6 col-lg-5">
                                <div className="leftsection-data">
                                    <div className="gridimg-inner">
                                        <div className="shap01">
                                            <ImageComp src='/images/whatwedo-pr.webp' alt="whatwedo-pr" width={554} height={581}  />
                                        </div>
                                        <div className="shap02">
                                            <ImageComp src='/images/whatwedo-pr02.webp' alt="whatwedo-pr02" width={322} height={366} />
                                        </div>
                                        <div className="shap03">
                                            <ImageComp src='/images/whatwedo-shap02.webp' alt="whatwedo-shap02" width={88} height={108}/>
                                        </div>
                                        <div className="shap04">
                                            <ImageComp src='/images/whatwedo-shap03.webp' alt="whatwedo-shap03" width={148} height={67}/>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div className="col-12 col-md-6 col-lg-7">
                                <div className="we-do-content subbox-data-content">
                                    <div className="dim-text">
                                        What we do
                                    </div>
                                    <h2 className="ds-title">
                                        Petroleum Products
                                    </h2>
                                    <p className="dec-text">
                                        Oil and petroleum products such as gasoline, jet fuel, diesel, marine oil and fuel oil are an essential part of the global energy mix today.
                                    </p>
                                    <p className="dec-text">
                                        It is used for transportation and by a wide range of industries. 
                                    </p>
                                    <p className="dec-text">
                                       Petroleum products continue to play an important role in supporting growing global energy demand during the transition currently underway to a low-carbon economy.
                                    </p>
                                    <p className="dec-text">
                                    As one of the premiere suppliers of energy products, we have significant expertise in offering the right product to customer and/or moving oil and petroleum products to customers around the world.
                                    </p>
                                    <div className="primary-btn">
                                        <Link href="/our-products" className="btnprimary">
                                            Explore More
                                            <svg width="19" height="20" viewBox="0 0 19 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <g clipPath="url(#clip0_2001_21)">
                                                <path d="M10.7027 2.77344L17.7742 9.33594C17.9617 9.51823 18.0554 9.73958 18.0554 10C18.0554 10.2604 17.9617 10.4818 17.7742 10.6641L10.7027 17.2266C10.2206 17.5911 9.76524 17.5911 9.33667 17.2266C8.96167 16.7578 8.96167 16.3151 9.33667 15.8984L14.6804 10.9375H1.01971C0.43042 10.8854 0.108991 10.5729 0.0554199 10C0.108991 9.42708 0.43042 9.11458 1.01971 9.0625H14.6804L9.33667 4.10156C8.96167 3.6849 8.96167 3.24219 9.33667 2.77344C9.76524 2.40885 10.2206 2.40885 10.7027 2.77344Z" fill="white"/>
                                                </g>
                                                <defs>
                                                <clipPath id="clip0_2001_21">
                                                <rect width="18" height="20" fill="white" transform="matrix(1 0 0 -1 0.0554199 20)"/>
                                                </clipPath>
                                                </defs>
                                            </svg>
                                        </Link>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div className="ourproduct-shap">
                    <ImageComp src='/images/Petroleum-Products-ani.webp' className="img-fluid" alt="Petroleum-Products-ani" width={374} height={212}  />
                </div>
            </section>
        </>
    );
}