import React from "react";
 
interface ChemicalFormulaProps {
  formula: string;
}
 
const ChemicalFormula: React.FC<ChemicalFormulaProps> = ({ formula }) => {
  const parts = formula.split(/(\d+)/).filter(Boolean);
 
  return (
    <span>
      {parts.map((part, i) =>
        /\d+/.test(part) ? <sub key={i}>{part}</sub> : <React.Fragment key={i}>{part}</React.Fragment>
      )}
    </span>
  );
};
 
export default ChemicalFormula;