

"use client";

import ChemicalFormula from "./ChemicalFormula";

interface Composition {
    id : number;
    key : string;
    value1 : string;
    value2 : string | null;
    value3 : string | null;
}

interface CompositionProps {
    compositions: Composition[];
}

export default function Composition({ compositions } : CompositionProps){
    return (
        <>    
            <div className="composition-box">
                <h6 className="title-pd">Composition</h6>
                {compositions.length === 0 ? (
                    <p>No Compositions.</p>
                ) : (
                    <div className="composition-list">
                        {compositions.map((composition) => (
                            <div className="composition-item" key={`composition-${composition.id}`}>
                                <div className="leftdata">
                                    <span className="notranslate"> {composition.key && <ChemicalFormula formula={composition.key} />}</span>
                                    <strong>{composition.value1}</strong>
                                </div>
                                {composition.value2 != null && (
                                    <div className="rightdata">
                                        <p>{composition.value2 ?? ""}</p>
                                    </div>
                                )}
                            </div>
                        ))}
                    </div>
                )}
            </div>
        </>
    );
}

