"use client";
import ProductImage from "../ProductImage";
interface Crop {
    id : number;
    title : string;
    key : string;
    uploads : any;
}
interface CropsProps {
    crops: Crop[] | [];
}

export default function Crops({ crops } : CropsProps){
    return (
        <>    
           <div className="crops-box">
                <h6 className="title-pd">
                    Crops
                </h6>
                {crops.length === 0 ? (
                    <p>No Crops.</p>
                ) : ( 
                    <div className="crops-list">                  
                       {crops.map((crop,index) => (
                            <div className="crop-item" key={index}>
                                <div className="icon">
                                <ProductImage image_path={crop?.uploads[0]?.file_path} title={crop?.title ?? 'crops image'}  width={77} height={77} />                                    
                                </div>
                                <div className="name-cp">
                                {crop?.title}
                                </div>
                            </div>
                        ))}
                    </div>
                )}
            </div>
            
        </>
    );
}

   



