"use client";

import { useEffect, useState } from "react";
import CategoriesSidebar from "@/components/Products/Categories-aside";
import ImageComp from "../Shared/Image";
import Link from "next/link";
import ProductImage from "@/components/Products/ProductImage";
import ProductDescription from "@/components/Products/ProductDescription";
import ViewButton from "@/components/Products/ViewButton";
import { Category } from "@/types/category";
import { Product } from "@/types/product";
import { getCategoryType } from "@/lib/storage";

interface ProductListingProps {
    products: Product[];
    categories: Category[];
    totalProducts: number;
}

export default function ProductListing({ products, categories, totalProducts }: ProductListingProps) {
    const [categoryType, setCategoryType] = useState<string>('');

    useEffect(() => {
        const categoryTypee = getCategoryType();
        if(categoryTypee){
            setCategoryType(categoryTypee);
        }
    });

    return (
        <>        
            <section className="product-listing-wrapper py-120">
                <div className="container">
                    <div className="row">
                        <div className="col-12 col-md-4 col-lg-3">
                            <CategoriesSidebar categories={categories} />
                        </div>
                        <div className="col-12 col-md-8 col-lg-9">
                            <div className="product-list">
                                <div className="product-list-count">
                                    <span>
                                        {totalProducts} Product(s) listed
                                    </span>
                                </div>
                                <div className="product-list-inner">
                                    {products.length === 0 ? (
                                        <p>No products available.</p>
                                    ) : (
                                        <ul className="product-list-pl">
                                            {products.map((prod) => (
                                                <li className="product-list-item-pl" key={prod.id}>
                                                    <div className="product-list-box">
                                                        <div className="product-list-img">
                                                            <ProductImage image_path={prod.productUploads[0]?.file_path} title={prod.title ?? 'product image'} width={90} height={176} />
                                                        </div>
                                                        <div className="product-list-content">
                                                            <h4>{prod.title ?? ''}</h4>

                                                            <ProductDescription html={prod.description} />

                                                            <ViewButton id={prod.id} categoryType={categoryType} subcategory={prod.subCategory.slug} category={prod.subCategory.category.slug} slug={prod.slug} />
                                                        </div>
                                                    </div>
                                                </li>
                                            ))}
                                        </ul>
                                    )}
                                    
                                    {products.length > 6 && (
                                    <div className="loard-more-btn">
                                        <Link href="javascript:void(0)" className="btnprimary">
                                            Load More
                                        </Link>
                                    </div>
                                    )}
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

                <div className="ourproduct-shap">
                    <ImageComp src="/images/ourproduct-shap-list.webp" height={162} width={130} alt="ourproduct-shap-list" />
                </div>
            </section>
        </>
    );
}