"use client";

import React from "react";
import { Swiper, SwiperSlide } from 'swiper/react';
import { Navigation, EffectCards } from 'swiper/modules';
import { SwiperOptions } from 'swiper/types';
import 'swiper/css';
import 'swiper/css/navigation';

type SliderProps = {
    modules : SwiperOptions['modules'];
    navigation: object;
    slidesPerView: number;
    className: string;
    grabCursor: boolean;
    slides: React.ReactNode[]; // Accepts an array of slide components
    section_name : string;
    effectName?: string;
    cardsEffect?:SwiperOptions['cardsEffect'];
    breakpoints?: SwiperOptions['breakpoints'];
};

const SwiperSlider = ({ modules, navigation, slidesPerView, className, grabCursor, slides, section_name, effectName, cardsEffect, breakpoints }: SliderProps) => {
    return (
        <Swiper
            modules={modules}
            effect={effectName}
            grabCursor={grabCursor}
            slidesPerView={slidesPerView}
            navigation={navigation}
            breakpoints={breakpoints}
            className={className}
            cardsEffect={cardsEffect}
        >
            {slides.map((slideContent, index) => (
                <SwiperSlide key={index}>{slideContent}</SwiperSlide>
            ))}
        </Swiper>
    );
};

export default SwiperSlider;
