"use client";

import Link from "next/link";

type ProductProps = {
    id: number;
    categoryType:string;
    subcategory : string;
    category : string;
    slug: string;
};

const ViewButton = ({ id, categoryType, subcategory, category, slug }: ProductProps) => {
    return (
        <Link href={`/${categoryType}/products/${category}/${subcategory}/${slug}`} className="view-btn">
            View
            <svg width="15" height="17" viewBox="0 0 15 17" fill="none" xmlns="http://www.w3.org/2000/svg">
                <g clipPath="url(#clip0_464_841)">
                <path d="M8.78125 2.78876L14.2812 8.03876C14.4271 8.18459 14.5 8.36167 14.5 8.57001C14.5 8.77834 14.4271 8.95542 14.2812 9.10126L8.78125 14.3513C8.40625 14.6429 8.05208 14.6429 7.71875 14.3513C7.42708 13.9763 7.42708 13.6221 7.71875 13.2888L11.875 9.32001H1.25C0.791667 9.27834 0.541667 9.02834 0.5 8.57001C0.541667 8.11167 0.791667 7.86167 1.25 7.82001H11.875L7.71875 3.85126C7.42708 3.51792 7.42708 3.16376 7.71875 2.78876C8.05208 2.49709 8.40625 2.49709 8.78125 2.78876Z" fill="currentcolor"/>
                </g>
                <defs>
                <clipPath id="clip0_464_841">
                <rect width="14" height="16" fill="white" transform="matrix(1 0 0 -1 0.5 16.57)"/>
                </clipPath>
                </defs>
            </svg>                                                    
        </Link>
    );
};
  
export default ViewButton;