import { Product } from '@/types/product';

interface ApiResponse {
    status: boolean;
    message: string;
    data: {
      data: Product | null; 
    };
}

const API_BASE_URL = process.env.NEXT_PUBLIC_API_BASE_URL || 'http://localhost:3000/api/v1';


export async function fetchProductDetails(slug?:string): Promise<Product | null> {
    try {
        const res = await fetch(`${API_BASE_URL}/product/${slug}`);
        
        if (!res.ok) {
            throw new Error('Failed to fetch product details');
        }

        const result: ApiResponse = await res.json();
        if (!result?.data?.data) {
            return null;
        }
        return result.data.data;
    } catch (error) {
        console.error('Product details fetch error:', error);
  
        // Return empty fallback for safe SSG
        return null;
    }
}
