import { SubCategory } from '@/types/subCategory';

interface ApiResponse {
  status: boolean;
  message: string;
  data: {
    data: SubCategory[];
    pagination: {
      totalItems: number;
      totalPages: number;
      currentPage: number;
      pageSize: number;
    };
  };
}

const API_BASE_URL = process.env.NEXT_PUBLIC_API_BASE_URL || 'http://localhost:3000/api/v1';

export async function fetchSubCategories(): Promise<SubCategory[]> {
  try { 
    const res = await fetch(`${API_BASE_URL}/sub-categories`);

    if (!res.ok) {
        throw new Error('Failed to fetch sub-categories');
    }

    const result: ApiResponse = await res.json();
    return result.data.data;
  } catch (error) {
    console.error('subcategory fetch error:', error);
    return [];
  }
}
