type SettingItem = {
    id: number;
    key: string;
    value: string | null;
};
  
export function mapSettingsByKey(
    settings: SettingItem[]
  ): Record<string, string | null> | null {
    try {
      const mapped: Record<string, string | null> = {};
      settings.forEach(item => {
        mapped[item.key] = item.value;
      });
      return mapped;
    } catch (error) {
      console.error("Error mapping settings:", error);
      return null;
    }
}